
/*:

@target MZ
@plugindesc プラグインコマンドに一部の制御文字を対応させます。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_PluginCommandConvert.js

プラグインコマンドに文章の表示で使う
「\V[n]、\N[n]、\P[n]、\G」が使えるようになります。

このプラグインがうまく動かない時はプラグイン管理の
順番を変えて試してください。

*/

(() => {
    
    const pluginName = "MK_PluginCommandConvert";
    
    //プラグインコマンド
    const _PluginManager_callCommand = PluginManager.callCommand;
    PluginManager.callCommand = function(self, pluginName, commandName, args) {
        let originallyArgs = {};
        for(let a in args){
            originallyArgs[a] = args[a];
            args[a] = MK_ConvertEscapeCharacters(args[a]);
        }
        _PluginManager_callCommand.apply(this, arguments);
        for(let a in args){
            args[a] = originallyArgs[a];
        }
    };
    
    MK_ConvertEscapeCharacters = function(text) {
        text = text.replace(/\\/g, "\x1b");
        text = text.replace(/\x1b\x1b/g, "\\");
        text = text.replace(/\x1bV\[(\d+)\]/gi, (_, p1) =>
            $gameVariables.value(parseInt(p1))
        );
        text = text.replace(/\x1bV\[(\d+)\]/gi, (_, p1) =>
            $gameVariables.value(parseInt(p1))
        );
        text = text.replace(/\x1bN\[(\d+)\]/gi, (_, p1) =>
            MK_ActorName(parseInt(p1))
        );
        text = text.replace(/\x1bP\[(\d+)\]/gi, (_, p1) =>
            MK_PartyMemberName(parseInt(p1))
        );
        text = text.replace(/\x1bG/gi, TextManager.currencyUnit);
        return text;
    };
    
    MK_ActorName = function(n) {
        const actor = n >= 1 ? $gameActors.actor(n) : null;
        return actor ? actor.name() : "";
    };
    
    MK_PartyMemberName = function(n) {
        const actor = n >= 1 ? $gameParty.members()[n - 1] : null;
        return actor ? actor.name() : "";
    };
    
    
})();
